unit Form_Schedule;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, BusinessSkinForm, ExtCtrls, MMObj, MMBmpLst, MMBmpBtn, MMPanel,
  MMFill, bsSkinCtrls, Grids, BaseGrid, AdvGrid, AdvCGrid, StdCtrls,
  abfControls, bsSkinShellCtrls, FileCtrl;

type
  TFormSchedule = class(TForm)
    Panel_player: TbsSkinPanel;
    bsSkinPanel1: TbsSkinPanel;
    MMPanelFill1: TMMPanelFill;
    MMPanelFill3: TMMPanelFill;
    MMPanelFill4: TMMPanelFill;
    MMPanelFill5: TMMPanelFill;
    MMBitmapButton3: TMMBitmapButton;
    load: TMMBitmapButton;
    MMPanelFill2: TMMPanelFill;
    bsBusinessSkinForm1: TbsBusinessSkinForm;
    MMPanelFill8: TMMPanelFill;
    MMPanelFill9: TMMPanelFill;
    StaticText11: TStaticText;
    abfEdit1: TabfEdit;
    MMPanelFill6: TMMPanelFill;
    MMBitmapButton7: TMMBitmapButton;
    MMBitmapButton5: TMMBitmapButton;
    schedule: TAdvColumnGrid;
    bsSkinPanel2: TbsSkinPanel;
    panel_patern: TbsSkinPanel;
    MMBitmapButton1: TMMBitmapButton;
    bsSkinPanel4: TbsSkinPanel;
    MMPanelFill7: TMMPanelFill;
    MMBitmapButton2: TMMBitmapButton;
    MMBitmapButton4: TMMBitmapButton;
    MMPanelFill10: TMMPanelFill;
    MMPanelFill11: TMMPanelFill;
    MMPanelFill12: TMMPanelFill;
    MMBitmapButton6: TMMBitmapButton;
    MMPanelFill13: TMMPanelFill;
    MMPanelFill14: TMMPanelFill;
    StaticText1: TStaticText;
    MMPanelFill15: TMMPanelFill;
    MMBitmapButton8: TMMBitmapButton;
    MMBitmapButton9: TMMBitmapButton;
    randomgrid: TAdvColumnGrid;
    MMBitmapButton10: TMMBitmapButton;
    MMBitmapButton11: TMMBitmapButton;
    selectdir: TbsSkinSelectDirectoryDialog;
    Timer1: TTimer;
    StaticText2: TStaticText;
    FileListBox1: TFileListBox;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    CheckBox1: TCheckBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ScheduleResize(Sender: TObject);
    procedure MMBitmapButton7Click(Sender: TObject);
    procedure MMBitmapButton1Click(Sender: TObject);
    procedure MMBitmapButton5Click(Sender: TObject);
    procedure ScheduleClick(Sender: TObject);
    procedure MMBitmapButton3Click(Sender: TObject);
    procedure loadClick(Sender: TObject);
    procedure StaticText11Click(Sender: TObject);
    procedure MMBitmapButton10Click(Sender: TObject);
    procedure MMBitmapButton11Click(Sender: TObject);
    procedure MMBitmapButton2Click(Sender: TObject);
    procedure MMBitmapButton4Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure MMBitmapButton6Click(Sender: TObject);
    procedure MMBitmapButton8Click(Sender: TObject);
    procedure MMBitmapButton9Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    function coltoname:string;
    procedure sched_color;
    { Public declarations }
  end;

var
  FormSchedule: TFormSchedule;

implementation

uses form_mainform, Form_playlist;

{$R *.dfm}

procedure TFormSchedule.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  width:=0;
  height:=0;
  FormStyle:=fsnormal;
  Visible:=false;
  mainform.AutoArrange1.Click;
end;

procedure TFormSchedule.ScheduleResize(Sender: TObject);
var i:integer;
begin
  for i:=1 to schedule.ColCount-1 do
  begin
    schedule.Columns.Items[i].Width:=((schedule.Width-schedule.Columns.Items[0].Width) div 7)-2;
  end;
  for i:=1 to schedule.RowCount-1 do
  begin
    schedule.RowHeights[i]:=(schedule.Height-schedule.RowHeights[0]) div 25;
  end;
end;

function TFormSchedule.coltoname:string;
var i:integer;
    text:string;
begin
  if schedule.Col<10 then text:='0'+inttostr(schedule.Col)      else text:=inttostr(schedule.Col);
  if schedule.row<10 then text:=text+'0'+inttostr(schedule.row) else text:=text+inttostr(schedule.Col);
  result:=text;
end;

procedure TFormSchedule.sched_color;
var i,j:integer;
begin
  for j:=2 to formschedule.Schedule.RowCount-1 do
  for i:=1 to formschedule.Schedule.ColCount-1 do
  begin
    if formschedule.Schedule.Cells[i,j]<>'' then
       formschedule.Schedule.Colors[i,j]:=clgray else
       formschedule.Schedule.Colors[i,j]:=clwhite;
  end;
end;

procedure TFormSchedule.MMBitmapButton7Click(Sender: TObject);
begin
  mainform.MusicLibrary1.Click;
end;

procedure TFormSchedule.MMBitmapButton1Click(Sender: TObject);
begin
  panel_patern.Visible:=True;
  ComboBox1.Items.Clear;
  mainform.db_patern.First;
  while not mainform.db_patern.Eof do
  begin
    if ComboBox1.Items.IndexOf(mainform.db_patern.FieldByName('Nama').AsString)<0 then ComboBox1.Items.Add(mainform.db_patern.FieldByName('Nama').AsString);
    mainform.db_patern.Next;
  end;
  ComboBox1.ItemIndex:=-1;
end;

procedure TFormSchedule.MMBitmapButton5Click(Sender: TObject);
begin
  if languages=0 then pesan:='Delete selected scedule?';
  if languages=1 then pesan:='Hapus jadual terpilih?';

  if mainform.message.MessageDlg(pesan,mtconfirmation,[mbyes,mbno],0)=mryes then
  begin
    mainform.db_sclist.First;
    while not mainform.db_sclist.Eof do
    begin
    if ( mainform.db_sclist.FieldByName('RBO_ID').AsString=RBO_ID) and
       ( mainform.db_sclist.FieldByName('Col').AsString=IntToStr(FormSchedule.schedule.Col)) and
       ( mainform.db_sclist.FieldByName('row').AsString=IntToStr(FormSchedule.schedule.row)) then
       begin
          mainform.db_sclist.Delete;
       end else mainform.db_sclist.Next;
    end;
    schedule.Cells[schedule.Col,schedule.Row]:='';
    schedule.OnClick(self);
    sched_color;
    schedule.SaveTofile(workdir+'share\schedule.dat');
  end;
end;

procedure TFormSchedule.ScheduleClick(Sender: TObject);
begin
  if schedule.Cells[schedule.Col,schedule.Row]<>'' then
     abfedit1.Text:=schedule.Cells[schedule.Col,schedule.Row] else
  begin
     abfedit1.Text:=schedule.Cells[schedule.col,0]+' '+schedule.Cells[schedule.col,1]+' '+schedule.Cells[0,schedule.row];
  end;

end;

procedure playlist2db;
var i:integer;
begin
  mainform.db_sclist.First;
  while not mainform.db_sclist.Eof do
  begin
    if ( mainform.db_sclist.FieldByName('RBO_ID').AsString=RBO_ID) and
       ( mainform.db_sclist.FieldByName('Col').AsString=IntToStr(FormSchedule.schedule.Col)) and
       ( mainform.db_sclist.FieldByName('row').AsString=IntToStr(FormSchedule.schedule.row)) then
       begin
          mainform.db_sclist.Delete;
       end else mainform.db_sclist.Next;
  end;

  for i:=1 to Playlist.Playlistgrid.RowCount-1 do
  begin
    mainform.db_sclist.Append;
    mainform.db_sclist.FieldByName('RBO_ID').AsString   :=RBO_ID;
    mainform.db_sclist.FieldByName('Col').AsString      :=IntToStr(FormSchedule.schedule.Col);
    mainform.db_sclist.FieldByName('Row').AsString      :=IntToStr(FormSchedule.schedule.row);
    mainform.db_sclist.FieldByName('Uptime').AsString   :=Playlist.Playlistgrid.Cells[0,i];
    mainform.db_sclist.FieldByName('Filename').AsString :=Playlist.Playlistgrid.Cells[1,i];
    mainform.db_sclist.FieldByName('length').AsString   :=Playlist.Playlistgrid.Cells[2,i];
    mainform.db_sclist.FieldByName('orilength').AsString:=Playlist.Playlistgrid.Cells[3,i];
    mainform.db_sclist.FieldByName('status').AsString   :=Playlist.Playlistgrid.Cells[4,i];
    mainform.db_sclist.FieldByName('RealName').AsString :=Playlist.Playlistgrid.Cells[5,i];
    mainform.db_sclist.FieldByName('filetype').AsString :=Playlist.Playlistgrid.Cells[6,i];
    if FormSchedule.checkbox1.checked then
       mainform.db_sclist.FieldByName('indexs').AsString   :='1' else//Playlist.Playlistgrid.Cells[7,i];
       mainform.db_sclist.FieldByName('indexs').AsString   :='';
    mainform.db_sclist.FieldByName('tablename').AsString:=FormSchedule.abfEdit1.Text;
    mainform.db_sclist.Post;
  end;
end;

procedure db2playlist;
begin
  Playlist.Playlistgrid.ClearRows(1,Playlist.Playlistgrid.RowCount);
  Playlist.Playlistgrid.RowCount:=2;
  mainform.db_sclist.Refresh;
  mainform.db_sclist.First;
  while not mainform.db_sclist.Eof do
  begin
    if ( mainform.db_sclist.FieldByName('RBO_ID').AsString=RBO_ID) and
       ( mainform.db_sclist.FieldByName('Col').AsString=IntToStr(FormSchedule.schedule.Col)) and
       ( mainform.db_sclist.FieldByName('row').AsString=IntToStr(FormSchedule.schedule.row)) then
       begin
          if Playlist.Playlistgrid.Cells[1,1]<>'' then Playlist.Playlistgrid.RowCount:=Playlist.Playlistgrid.RowCount+1;
          Playlist.Playlistgrid.Cells[0,Playlist.Playlistgrid.RowCount-1]:=mainform.db_sclist.FieldByName('uptime').AsString;
          Playlist.Playlistgrid.Cells[1,Playlist.Playlistgrid.RowCount-1]:=mainform.db_sclist.FieldByName('filename').AsString;
          Playlist.Playlistgrid.Cells[2,Playlist.Playlistgrid.RowCount-1]:=mainform.db_sclist.FieldByName('length').AsString;
          Playlist.Playlistgrid.Cells[3,Playlist.Playlistgrid.RowCount-1]:=mainform.db_sclist.FieldByName('Orilength').AsString;
          Playlist.Playlistgrid.Cells[4,Playlist.Playlistgrid.RowCount-1]:=mainform.db_sclist.FieldByName('Status').AsString;
          Playlist.Playlistgrid.Cells[5,Playlist.Playlistgrid.RowCount-1]:=mainform.db_sclist.FieldByName('Realname').AsString;
          Playlist.Playlistgrid.Cells[6,Playlist.Playlistgrid.RowCount-1]:=mainform.db_sclist.FieldByName('filetype').AsString;
          Playlist.Playlistgrid.Cells[7,Playlist.Playlistgrid.RowCount-1]:='';//mainform.db_sclist.FieldByName('indexs').AsString;
          if mainform.db_sclist.FieldByName('indexs').AsString='1' then playlistlock:=True else playlistlock:=False;
       end;
       mainform.db_sclist.Next;
  end;
end;

procedure TFormSchedule.MMBitmapButton3Click(Sender: TObject);
begin
  if abfedit1.Text<>'' then
  begin
    playlist2db;
    schedule.Cells[schedule.col,schedule.row]:=abfedit1.Text;
    schedule.SaveTofile(workdir+'share\schedule.dat');
    sched_color;
    hariprev:=date-10;
    abfedit1.SetFocus;
    if languages=0 then mainform.message.MessageDlg('Successfully grab playlist to schedule!',mtconfirmation,[mbok],0);
    if languages=1 then mainform.message.MessageDlg('Playlist telah berhasil dimasukkan dalam jadual!',mtconfirmation,[mbok],0);
  end else
  begin
    if languages=0 then mainform.message.MessageDlg('Please type playlist title!',mtconfirmation,[mbok],0);
    if languages=1 then mainform.message.MessageDlg('Ketikkan judul playlist!',mtconfirmation,[mbok],0);
  end;
end;

procedure TFormSchedule.loadClick(Sender: TObject);
begin
  //if fileexists(workdir+'share\playlist\'+coltoname) then
  begin
    //playlist.Playlistgrid.LoadFromfile(workdir+'share\playlist\'+coltoname);
    db2playlist;
    playlist.playtitle.Caption:=schedule.Cells[schedule.Col,schedule.Row];
  end;
  { else
  begin
    if languages=0 then mainform.message.MessageDlg('Cannot add empty schedule!',mtconfirmation,[mbok],0);
    if languages=1 then mainform.message.MessageDlg('Tidak dapat menambah jadual kosong!',mtconfirmation,[mbok],0);
  end;
  }
end;

procedure TFormSchedule.StaticText11Click(Sender: TObject);
begin
  //schedule.Cells[2,1]:='TESTING';
end;

procedure TFormSchedule.MMBitmapButton10Click(Sender: TObject);
begin
  if selectdir.Execute then
  begin
    if randomgrid.Cells[0,1]<>'' then randomgrid.RowCount:=randomgrid.RowCount+1;  
    randomgrid.Cells[0,randomgrid.RowCount-1]:=IntToStr(randomgrid.RowCount-1);
    randomgrid.Cells[1,randomgrid.RowCount-1]:=selectdir.Directory;
    randomgrid.Cells[2,randomgrid.RowCount-1]:='1';
  end;
end;

procedure TFormSchedule.MMBitmapButton11Click(Sender: TObject);
begin
  if randomgrid.rowcount>2 then randomgrid.RemoveRows(randomgrid.Row,1) else
     randomgrid.ClearRows(1,1);
end;

procedure TFormSchedule.MMBitmapButton2Click(Sender: TObject);
begin
  panel_patern.Visible:=false;
end;

procedure TFormSchedule.MMBitmapButton4Click(Sender: TObject);
begin
  randomgrid.ClearRows(1,randomgrid.RowCount-1);
  randomgrid.RowCount:=2;
end;

procedure TFormSchedule.Timer1Timer(Sender: TObject);
var i,count:Integer;
begin
  count:=0;
  for i:=1 to randomgrid.RowCount-1 do
  begin
    if randomgrid.Cells[2,i]<>'' then count:=count+strtoint(randomgrid.Cells[2,i]);
  end;
  statictext2.Caption:='Total : '+inttostr(count);
end;

Procedure add_playlist(filename:string);
begin
   if FileExists(filename) then
   with playlist do
   begin
    if playlistgrid.Cells[1,1]<>'' then playlistgrid.RowCount:=playlistgrid.RowCount+1;
    playlistgrid.cells[1,playlistgrid.RowCount-1]:=extractfilename(filename);
    playlistgrid.Cells[5,playlistgrid.RowCount-1]:=filename;
    playlistgrid.Cells[0,playlistgrid.RowCount-1]:='WAITING';

    playlistgrid.Cells[6,playlistgrid.RowCount-1]:='MUSIC';

    mpegfile.FileName:=filename;

    playlistgrid.Cells[3,playlistgrid.RowCount-1]:=inttostr  (mpegfile.Frames * mpegfile.TimePerFrame);
    playlistgrid.Cells[2,playlistgrid.RowCount-1]:=MSecToTime(mpegfile.Frames * mpegfile.TimePerFrame);

    mpegfile.FreeMpeg;

    cek_total;

    playlistindex:=mainform.getindex;
    mainform.settimeup(playlistindex);
    mainform.playlist_color;

    playlist.playlistgrid.AutoSizeRows(false,0);
    playlist.Playlistgrid.SaveTofile(savedir+'setting\playlist.dat');
   end;
end;

procedure TFormSchedule.MMBitmapButton6Click(Sender: TObject);
var i,j,k,maximum:integer;
begin
  Form_playlist.Playlist.ClearPlaylist1.OnClick(Self);
  ComboBox2.Items.Clear;

  for i:=1 to randomgrid.RowCount-1 do
  begin
    if randomgrid.Cells[2,i]<>'' then
    begin
      FileListBox1.Directory:=randomgrid.Cells[1,i];
      FileListBox1.Update;
      FileListBox1.Refresh;

      if StrToInt(randomgrid.Cells[2,i])>FileListBox1.Items.Count then maximum:=FileListBox1.Items.Count else maximum:=StrToInt(randomgrid.Cells[2,i]);

      Randomize;

      for k:=1 to maximum do
      begin
        repeat
          j:=Random(FileListBox1.Items.Count);
          filelistbox1.itemindex:=j;
        until ComboBox2.Items.IndexOf(filelistbox1.filename)<0;
        add_playlist(filelistbox1.filename);
        ComboBox2.Items.Add(filelistbox1.filename);
      end;

    end;
  end;
end;

procedure TFormSchedule.MMBitmapButton8Click(Sender: TObject);
var i:Integer;
    temp:string;
begin
  //MMBitmapButton9.OnClick(Self);

  if (randomgrid.Cells[0,1]<>'') and (ComboBox1.Text<>'') then
  begin
    mainform.db_patern.First;
    while not mainform.db_patern.Eof do
    begin
      if mainform.db_patern.FieldByName('Nama').AsString=ComboBox1.Text then
         mainform.db_patern.Delete else
      mainform.db_patern.Next;
    end;

    for i:=1 to randomgrid.RowCount-1 do
    begin
      mainform.db_patern.Append;
      mainform.db_patern.FieldByName('Nama').AsString  :=ComboBox1.Text;
      mainform.db_patern.FieldByName('Folder').AsString:=randomgrid.Cells[1,i];
      mainform.db_patern.FieldByName('Total').AsString :=randomgrid.Cells[2,i];
      mainform.db_patern.Post;
    end;
  end;


  temp:=combobox1.text;

  ComboBox1.Items.Clear;

  mainform.db_patern.First;
  while not mainform.db_patern.Eof do
  begin
    if ComboBox1.Items.IndexOf(mainform.db_patern.FieldByName('Nama').AsString)<0 then ComboBox1.Items.Add(mainform.db_patern.FieldByName('Nama').AsString);
    mainform.db_patern.Next;
  end;

  combobox1.text:=temp;

end;

procedure TFormSchedule.MMBitmapButton9Click(Sender: TObject);
begin
  if ComboBox1.text<>'' then
  begin
    mainform.db_patern.First;
    while not mainform.db_patern.Eof do
    begin
      if mainform.db_patern.FieldByName('Nama').AsString=ComboBox1.Text then
         mainform.db_patern.Delete else
      mainform.db_patern.Next;
    end;

    ComboBox1.Items.Clear;

    mainform.db_patern.First;
    while not mainform.db_patern.Eof do
    begin
      if ComboBox1.Items.IndexOf(mainform.db_patern.FieldByName('Nama').AsString)<0 then ComboBox1.Items.Add(mainform.db_patern.FieldByName('Nama').AsString);
      mainform.db_patern.Next;
    end;
    combobox1.ItemIndex:=-1;

    MMBitmapButton4.OnClick(Self);
  end;
end;

procedure TFormSchedule.ComboBox1Change(Sender: TObject);
begin
  randomgrid.ClearRows(1,randomgrid.RowCount-1);
  randomgrid.RowCount:=2;
  mainform.db_patern.First;
  while not mainform.db_patern.Eof do
  begin
      if mainform.db_patern.FieldByName('Nama').AsString=ComboBox1.Text then
      begin
          if randomgrid.Cells[0,1]<>'' then randomgrid.RowCount:=randomgrid.RowCount+1;
          randomgrid.Cells[0,randomgrid.RowCount-1]:=IntToStr(randomgrid.RowCount-1);
          randomgrid.Cells[1,randomgrid.RowCount-1]:=mainform.db_patern.FieldByName('Folder').asstring;
          randomgrid.Cells[2,randomgrid.RowCount-1]:=mainform.db_patern.FieldByName('Total').asstring;
      end;
      mainform.db_patern.Next;
  end;
end;

procedure TFormSchedule.CheckBox1Click(Sender: TObject);
begin
  mainform.db_sclist.First;
  while not mainform.db_sclist.Eof do
  begin
    if ( mainform.db_sclist.FieldByName('RBO_ID').AsString=RBO_ID) and
       ( mainform.db_sclist.FieldByName('Col').AsString=IntToStr(FormSchedule.schedule.Col)) and
       ( mainform.db_sclist.FieldByName('row').AsString=IntToStr(FormSchedule.schedule.row)) then
       begin
          mainform.db_sclist.Edit;
          if CheckBox1.Checked then
             mainform.db_sclist.FieldByName('indexs').AsString:='1' else
             mainform.db_sclist.FieldByName('indexs').AsString:='';
          mainform.db_sclist.Post;
       end;
    mainform.db_sclist.Next;
  end;
end;

end.
